/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/    

/**
 * \file    main.c
 *
 * \brief   Entry point routines for testing SPI-NAND Flash on EVM
 *
 * This file contains the Entry point routine for testing SPI-NAND Flash on EVM.
 *
 * \author  0043
 *
 * \version 01a,13sep,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_EVM.h"
#include "DM814x_types.h"
#include "stdio.h"
#include "stdlib.h"

 /*
 *====================
 * Function implementations
 *====================
 */
void TEST_execute( STATUS ( *funchandle )( INT16 power_cycle_test), char *testname, INT16 testid )
{
    INT16 status;

    /* Display test ID */
    printf( "%02d  Testing %s...\n", testid, testname );

    /* Call test function */
    if (testid)
		status = funchandle(1);
    else
    	status = funchandle(0);

    /* Check for test fail */
    if ( status != 0 )
    {
        /* Print error message */
        printf( "     FAIL... error code %d... quitting\n", status );
    }
    else
    {
        /* Print error message */
        printf( "    PASS\n" );
    }
}

extern STATUS spiflash_test(INT16 power_cycle_test);

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  main( )                                                                 *
 *                                                                          *
 * ------------------------------------------------------------------------ */
void main(void)
{
    INT16 power_cycle_test = 0;

	/* Initialize EVM */
	DM814x_EVM_Init ();

    if (power_cycle_test)
    {
		TEST_execute( spiflash_test,  "spiflash", 1 );
    }
    else
    {
		TEST_execute( spiflash_test,  "spiflash", 0 );
    }

    printf( "\n***ALL Tests Done***\n" );
}
